% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\name{sql_query}
\alias{sql_query}
\alias{sql_exec}
\title{Run an SQL query or statement}
\usage{
sql_query(sql, conn = default_conn())

sql_exec(sql, conn = default_conn())
}
\arguments{
\item{sql}{A SQL string}

\item{conn}{An optional connection, defaults to \code{\link[=default_conn]{default_conn()}}}
}
\value{
A data frame with the query result
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{sql_query()} runs an arbitrary SQL query using \code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}}
and returns a \link{data.frame} with the query results.
\code{sql_exec()} runs an arbitrary SQL statement using \code{\link[DBI:dbExecute]{DBI::dbExecute()}}
and returns the number of affected rows.

These functions are intended as an easy way to interactively run DuckDB
without having to manage connections.
By default, data frame objects are available as views.

Scripts and packages should manage their own connections
and prefer the DBI methods for more control.
}
\examples{
# Queries
sql_query("SELECT 42")

# Statements with side effects
sql_exec("CREATE TABLE test (a INTEGER, b VARCHAR)")
sql_exec("INSERT INTO test VALUES (1, 'one'), (2, 'two')")
sql_query("FROM test")

# Data frames available as views
sql_query("FROM mtcars")
}
