% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/belplauHQQ.R
\name{belplauHQQ}
\alias{belplauHQQ}
\title{Compute belief, disbelief, unknown, plausibility, plausibility ratio based on commonality function}
\usage{
belplauHQQ(qq, h = NULL)
}
\arguments{
\item{qq}{Commonality function}

\item{h}{= NULL Hypothesis to be evaluated}
}
\value{
z A matrix of \code{M} rows by 5 columns is returned, where \code{M} is the number of hypothesis tested: \itemize{
 \item Column 1: the degree of Belief \code{bel};
 \item Column 2: the degree of Disbellief (belief in favor of the contrary hypothesis) \code{disbel};
 \item Column 3: the degree of Epistemic uncertainty \code{unc};
 \item Column 4: the degree of Plausibility \code{plau};
 \item Column 5: the Plausibility ratio \code{rplau}.
   }
}
\description{
Compute belief, disbelief, unknown, plausibility, plausibility ratio based on commonality function
}
\examples{
x <- bca(tt = matrix(c(0,1,1,1,1,0,1,1,1),nrow = 3, byrow = TRUE),
m = c(0.2,0.5, 0.3), cnames = c("a", "b", "c"), varnames = "x", idvar = 1)
qq <- commonality(x$tt,x$spec[,2])
belplauHQQ(qq,h=matrix(c(0,1,0), nrow=1, byrow=TRUE))
}
\author{
Peiyuan Zhu
}
