% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dsm_30.R
\name{get_dsm_30}
\alias{get_dsm_30}
\title{get_dsm_30}
\usage{
get_dsm_30(x, y, r, epsg, bbox, global = TRUE, datatype = "AW3D30", key = "")
}
\arguments{
\item{x}{numeric, indicating Longtitude degree of the center point.}

\item{y}{numeric, indicating latitude degree of the center point.}

\item{r}{numeric, indicating search distance (meter or feet) for LiDAR data.}

\item{epsg}{numeric, the EPSG code specifying the coordinate reference system.}

\item{bbox}{vector, a bounding box defining the geographical area for downloading data.}

\item{global}{logic, if true, AW3D30 data will be downloaded.}

\item{datatype}{character, dataset names including "AW3D30", "USGS1m", "USGS10m".}

\item{key}{character, API key of OpenTopography.}
}
\value{
raster
}
\description{
Search for and download ALOS Global Digital Surface Model (AW3D30) and
USGS DEM raster datasets via OpenTopography API 1.0.0 based on coordinates of a spatial
point with a given distance or bounding box. The AW3D30 raster resolution is 30 meter.
The resolutions of USGS datasets are 10m and 1m.
}
\details{
To request an API key of OpenTopography, online registeration is needed.
}
\examples{
\dontrun{
data <- dsmSearch::get_dsm_30(bbox = c(-83.783557,42.241833,-83.696525,42.310420),
                              key = "API key")
data <- dsmSearch::get_dsm_30(x = -83.741289,
                              y = 42.270146,
                              r = 1000,
                              epsg = 2253,
                              key = "API key")
}

}
