\name{curvature}
\alias{curvature}
\alias{curvature.default}
\alias{curvature.Darray}
\alias{curvature.TSestModel}

\title{curvature}
\description{Curvature calculations and summary statistics as in Bates and Watts.
}
\usage{
	curvature(func, x, signif = 0.05, show.details = F, track=F)
	curvature(Dlist,   signif = 0.05, show.details = F, track=F)
}
\arguments{
The function is generic. It can be called with a function and parameter matrix,
 in which case the Bates and Watts D matrix is calculated, or with a previously
 calculated D matrix.

\item{ func, x,}
{func is a function which returns a sample space vector at the 
parameter value x.}
\item{ Dlist}
{Dlist is a list as generated by genD,
       with the 3 elements as follows:
   $D is a matrix of first(gradients) and second order partial
      derivatives organized in the same manner as Bates and 
      Watts. (first p columns are the gradients and the 
      next p(p-1)/2 columns are the lower triangle of the Hessian).
   $p is the dimension of the parameter space=dim of the tangent space.
   $f0 is the function value at the point where the matrix D 
        was calculated. (The calculation should not/does not? depend on
        this value - but it should be the right dimension and 0's do
        not work.

}
\item{ signif}{The significance level to }
\item{ show.details}{If show.details=T then intermediate calculations are printed.}
\item{ track}{If track=T then the progress of the calculations is printed.}
}
\value{
A list is returned (with invisible). Curvature summary statistics as in Bates and Watts are in the element $stat. A representation of the Bates and Watts D matrix is in the element $Dlist. The curvature array C as in Batts and Watts defn. (7.16) p242 and examples p244 &  p245 is in the elements $C.parameter and
 $C.intrinsic.
}
\sideffects{
Curvature summary statistics as in Bates and Watts are printed.
}
\section{ REFERENCES} 
See Bates and Watts(1983), 'Nonlinear Regression Analysis and Its Applications.'
}
\seealso{
\code{\link{genD}}
}
\examples{
if(is.R()) data("eg1.DSE.data.diff", package="dse1")
model <- est.VARX.ls(TSdata( output=output.data(eg1.DSE.data.diff, series=1:2)),
                     max.lag=2)
curvature(genD(model)) 
}
\keyword{DSE}
\keyword{ts}

