% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fun.R
\name{plot_text}
\alias{plot_text}
\title{Plot text characters (from file or user input).}
\usage{
plot_text(
  file = "",
  char_bg = " ",
  lbl_tiles = TRUE,
  lbl_rotate = FALSE,
  cex = 3,
  fontface = 1,
  family = "sans",
  col_lbl = "black",
  col_bg = "white",
  pal = pal_ds4psy[1:5],
  pal_extend = TRUE,
  case_sense = FALSE,
  borders = TRUE,
  border_col = "white",
  border_size = 0.5
)
}
\arguments{
\item{file}{The text file to read (or its path). 
If \code{file = ""} (the default), \code{scan} is used 
to read user input from the Console. 
If a text file is stored in a sub-directory, 
enter its path and name here (without any leading or 
trailing "." or "/"). 
Default: \code{file = ""}.}

\item{char_bg}{Character used as background. 
Default: \code{char_bg = " "}. 
If \code{char_bg = NA}, the most frequent character is used.}

\item{lbl_tiles}{Add character labels to tiles? 
Default: \code{lbl_tiles = TRUE} (i.e., show labels).}

\item{lbl_rotate}{Rotate character labels? 
Default: \code{lbl_rotate = FALSE} (i.e., no rotation).}

\item{cex}{Character size (numeric). 
Default: \code{cex = 3}.}

\item{fontface}{Font face of text labels (numeric). 
Default: \code{fontface = 1}, (from 1 to 4).}

\item{family}{Font family of text labels (name).
Default: \code{family = "sans"}. 
Alternative options: "sans", "serif", or "mono".}

\item{col_lbl}{Color of text labels.
Default: \code{col_lbl = "black"} (if \code{lbl_tiles = TRUE}).}

\item{col_bg}{Color of \code{char_bg} (if defined), 
or the most frequent character in text (typically \code{" "}). 
Default: \code{col_bg = "white"}.}

\item{pal}{Color palette for filling tiles 
of text (used in order of character frequency). 
Default: \code{pal = pal_ds4psy[1:5]} 
(i.e., shades of \code{Seeblau}).}

\item{pal_extend}{Boolean: Should pal be extended 
to match the number of different characters in text? 
Default: \code{pal_extend = TRUE}. 
If \code{pal_extend = FALSE}, only the tiles of 
the \code{length(pal)} most frequent characters 
will be filled by the colors of \code{pal}.}

\item{case_sense}{Boolean: Should lower- and 
uppercase characters be distinguished? 
Default: \code{case_sense = FALSE}.}

\item{borders}{Boolean: Add borders to tiles? 
Default: \code{borders = TRUE} (i.e., use borders).}

\item{border_col}{Color of borders (if \code{borders = TRUE}). 
Default: \code{border_col = "white"}.}

\item{border_size}{Size of borders (if \code{borders = TRUE}). 
Default: \code{border_size = 0.5}.}
}
\description{
\code{plot_text} parses text 
(from a file or from user input in Console) 
into a table and then plots all 
its characters as a tile plot (using \strong{ggplot2}).
}
\examples{
## Create a temporary file "test.txt":
# cat("Hello world!", "This is a test.", 
#     "Can you see this text?", 
#     "Good! Please carry on...", 
#     file = "test.txt", sep = "\n")

## (a) Plot text (from file): 
# plot_text("test.txt")

## Set colors, pal_extend, and case_sense:
# cols <- c("steelblue", "skyblue", "lightgrey")
# cols <- c("firebrick", "olivedrab", "steelblue", "orange", "gold")
# plot_text("test.txt", pal = cols, pal_extend = TRUE)
# plot_text("test.txt", pal = cols, pal_extend = FALSE)
# plot_text("test.txt", pal = cols, pal_extend = FALSE, case_sense = TRUE)

## Customize text and grid options:
# plot_text("test.txt", col_lbl = "darkblue", cex = 4, family = "sans", fontface = 3,
#           pal = "gold1", pal_extend = TRUE, border_col = NA)
# plot_text("test.txt", family = "serif", cex = 6, lbl_rotate = TRUE,  
#           pal = NA, borders = FALSE)
# plot_text("test.txt", col_lbl = "white", pal = c("green3", "black"),
#           border_col = "black", border_size = .2)

## Color ranges:
# plot_text("test.txt", pal = c("red2", "orange", "gold"))
# plot_text("test.txt", pal = c("olivedrab4", "gold"))

# unlink("test.txt")  # clean up (by deleting file).
 
\donttest{
## (b) Plot text (from file in subdir):
# plot_text("data-raw/txt/hello.txt")  # requires txt file
# plot_text(file = "data-raw/txt/ascii.txt", cex = 5, 
#           col_bg = "grey", char_bg = "-")
         
## (c) Plot text input (from console):
# plot_text()
 
}

}
\seealso{
\code{\link{read_ascii}} for reading text into a table; 
\code{\link{pal_ds4psy}} for default color palette.

Other plot functions: 
\code{\link{plot_fn}()},
\code{\link{plot_fun}()},
\code{\link{plot_n}()},
\code{\link{plot_tiles}()},
\code{\link{theme_clean}()},
\code{\link{theme_ds4psy}()},
\code{\link{theme_empty}()}
}
\concept{plot functions}
