% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_fun.R
\name{num_as_char}
\alias{num_as_char}
\title{Convert a number into a character sequence.}
\usage{
num_as_char(x, n_pre_dec = 2, n_dec = 2, sym = "0", sep = ".")
}
\arguments{
\item{x}{Number(s) to convert (required, accepts numeric vectors).}

\item{n_pre_dec}{Number of digits before the decimal separator. 
Default: \code{n_pre_dec = 2}. 
This value is used to add zeros to the front of numbers. 
If the number of meaningful digits prior to decimal separator is greater than 
\code{n_pre_dec}, this value is ignored.}

\item{n_dec}{Number of digits after the decimal separator. 
Default: \code{n_dec = 2}.}

\item{sym}{Symbol to add to front or back. 
Default: \code{sym = 0}. 
Using \code{sym = " "} or \code{sym = "_"} can make sense, 
digits other than \code{"0"} do not.}

\item{sep}{Decimal separator to use.
Default: \code{sep = "."}.}
}
\description{
\code{num_as_char} converts a number into a character sequence 
(of a specific length).
}
\details{
The arguments \code{n_pre_dec} and \code{n_dec} set a number of desired digits 
before and after the decimal separator \code{sep}. 
\code{num_as_char} tries to meet these digit numbers by adding zeros to the front 
and end of \code{x}. However, when \code{n_pre_dec} is lower than the 
number of relevant (pre-decimal) digits, all relevant digits are shown. 

\code{n_pre_dec} also works for negative numbers, but 
the minus symbol is not counted as a (pre-decimal) digit. 

\strong{Caveat:} Note that this function illustrates how numbers, 
characters, \code{for} loops, and \code{paste()} can be combined 
when writing functions. It is not written efficiently or well.
}
\examples{
num_as_char(1)
num_as_char(10/3)
num_as_char(1000/6) 

# rounding down:
num_as_char((1.3333), n_pre_dec = 0, n_dec = 0)
num_as_char((1.3333), n_pre_dec = 2, n_dec = 0)
num_as_char((1.3333), n_pre_dec = 2, n_dec = 1)

# rounding up: 
num_as_char(1.6666, n_pre_dec = 1, n_dec = 0)
num_as_char(1.6666, n_pre_dec = 1, n_dec = 1)
num_as_char(1.6666, n_pre_dec = 2, n_dec = 2)
num_as_char(1.6666, n_pre_dec = 2, n_dec = 3)

# Note: If n_pre_dec is too small, actual number is kept:
num_as_char(11.33, n_pre_dec = 0, n_dec = 1)
num_as_char(11.66, n_pre_dec = 1, n_dec = 1)

# Note:
num_as_char(1, sep = ",")
num_as_char(2, sym = " ")
num_as_char(3, sym = " ", n_dec = 0)

# for vectors:
num_as_char(1:10/1, n_pre_dec = 1, n_dec = 1)
num_as_char(1:10/3, n_pre_dec = 2, n_dec = 2)

# for negative numbers (adding relevant pre-decimals):
mix <- c(10.33, -10.33, 10.66, -10.66)
num_as_char(mix, n_pre_dec = 1, n_dec = 1)
num_as_char(mix, n_pre_dec = 1, n_dec = 0)

# Beware of bad inputs:
num_as_char(4, sym = "8")
num_as_char(5, sym = "99")

}
\seealso{
Other utility functions: 
\code{\link{is_equal}()},
\code{\link{is_vector}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}
}
\concept{utility functions}
