% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{capitalize}
\alias{capitalize}
\title{Capitalize initial characters in strings of text \code{x}.}
\usage{
capitalize(x, n = 1, upper = TRUE, as_text = TRUE)
}
\arguments{
\item{x}{A string of text (required).}

\item{n}{Number of initial characters to convert.
Default: \code{n = 1}.}

\item{upper}{Convert to uppercase?
Default: \code{upper = TRUE}.}

\item{as_text}{Return word vector as text 
(i.e., one character string)? 
Default: \code{as_text = TRUE}.}
}
\value{
A character vector.
}
\description{
\code{capitalize} converts the case of 
each word's \code{n} initial characters 
(typically to \code{upper}) 
in a string of text \code{x}.
}
\examples{
x <- c("Hello world! This is a 1st TEST sentence. The end.")
capitalize(x)
capitalize(x, n = 3)
capitalize(x, n = 2, upper = FALSE)
capitalize(x, as_text = FALSE)

# Note: A vector of character strings returns the same results: 
x <- c("Hello world!", "This is a 1st TEST sentence.", "The end.")
capitalize(x)
capitalize(x, n = 3)
capitalize(x, n = 2, upper = FALSE)
capitalize(x, as_text = FALSE)

}
\seealso{
\code{\link{caseflip}} for converting the case of all letters.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{l33t_rul35}},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
