% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{what_month}
\alias{what_month}
\title{What month is it?}
\usage{
what_month(when = Sys.time(), abbr = FALSE, as_integer = FALSE)
}
\arguments{
\item{when}{Date (as a scalar or vector).
Default: \code{when = NA}. 
Using \code{as.Date(when)} to convert strings into dates, 
and \code{Sys.Date()}, if \code{when = NA}.}

\item{abbr}{Boolean: Return abbreviated?
Default: \code{abbr = FALSE}.}

\item{as_integer}{Boolean: Return as integer? 
Default: \code{as_integer = FALSE}.}
}
\description{
\code{what_month} provides a satisficing version of 
to determine the month corresponding to a given date.
}
\details{
\code{what_month} returns the month    
of \code{when} or \code{Sys.Date()} 
(as a name or number).
}
\examples{
what_month()
what_month(abbr = TRUE)
what_month(as_integer = TRUE)

# Work with vectors (when as characters):
ds <- c("2020-01-01", "2020-02-29", "2020-12-24", "2020-12-31")
what_month(when = ds)
what_month(when = ds, abbr = TRUE, as_integer = FALSE)
what_month(when = ds, abbr = TRUE, as_integer = TRUE)

    
}
\seealso{
\code{what_week()} function to obtain weeks; 
\code{what_date()} function to obtain dates; 
\code{cur_time()} function to print the current time; 
\code{cur_date()} function to print the current date; 
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{what_date}()},
\code{\link{what_day}()},
\code{\link{what_time}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
