% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fun.R
\name{sample_date}
\alias{sample_date}
\title{Draw a sample of n random dates (from a given range).}
\usage{
sample_date(n = 1, from = "1970-01-01", to = Sys.Date())
}
\arguments{
\item{n}{Number dates to draw. 
Default: \code{n = 1}.}

\item{from}{Earliest date (as string). 
Default: \code{from = "1970-01-01"}.}

\item{to}{Latest date (as string). 
Default: \code{to = Sys.Date()}.}
}
\description{
\code{sample_date} draws a sample of  
\code{n} random dates from a given range.
}
\details{
By default, \code{sample_date} draws \code{n = 1} 
random date in the range 
\code{from = "1970-01-01"} 
\code{to = Sys.Date()} (current date).
}
\examples{
sample_date()
sort(sample_date(n = 10))
sort(sample_date(n = 10, from = "2020-02-28", to = "2020-03-01"))  # 2020 is a leap year

# Note: Oddity with sample():
sort(sample_date(n = 10, from = "2020-01-01", to = "2020-01-01"))  # range of 0!
# see sample(9:9, size = 10, replace = TRUE)

}
\seealso{
Other sampling functions: 
\code{\link{coin}()},
\code{\link{dice_2}()},
\code{\link{dice}()},
\code{\link{sample_char}()},
\code{\link{sample_time}()}
}
\concept{sampling functions}
