% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{cur_time}
\alias{cur_time}
\title{Current time (in hh:mm or hh:mm:ss format).}
\usage{
cur_time(seconds = FALSE, sep = ":")
}
\arguments{
\item{seconds}{Boolean: Show time with seconds?
Default: \code{seconds = FALSE}.}

\item{sep}{Character: Separator to use. 
Default: \code{sep = ":"}.}
}
\description{
\code{cur_time} provides a satisficing version of 
\code{Sys.time()} that is sufficient for most purposes.
}
\details{
\code{cur_time} returns \code{Sys.time()}  
(in "%H:%M" or "%H:%M:%S" format) 
using current system settings.

For a time zone argument, 
see the \code{now()} function of 
the \strong{lubridate} package.
}
\examples{
cur_time() 
cur_time(seconds = TRUE)
cur_time(sep = ".")

}
\seealso{
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{cur_date}()},
\code{\link{what_date}()},
\code{\link{what_day}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
