% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_duration}
\alias{impute_duration}
\title{Replace missing or implausible prescription durations}
\usage{
impute_duration(
  data,
  method,
  where = is.na,
  group = c("patid", "start_date"),
  ...
)
}
\arguments{
\item{data}{A data frame containing columns \code{prodcode}, \code{pracid}, \code{patid}}

\item{method}{Method for imputing the values. See details.}

\item{where}{Logical vector, or function applied to \code{variable} returning such a vector, indicating which elements to impute. Defaults to \code{\link[base:NA]{is.na}}}

\item{group}{Level of structure for imputation. Defaults to whole study population.}

\item{...}{Extra arguments, currently ignored}
}
\value{
A data frame of the same structure as \code{data}, with values imputed
}
\description{
Instead of replacing missing stop dates, we impute the durations and then
infer the stop dates from there.
}
\details{
We can fix clashing start dates by setting \code{group} to \code{start_date}
and \code{patid}, i.e. average over groups with more than one member;
any metric should return the original values if the group size is one.
}
\examples{
example_duration <- transform(example_therapy, duration = qty / ndd)
impute_duration(example_duration, method = 'mean', group = 'patid')

}
