% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{deps_profile}
\alias{deps_profile}
\title{Find out why a target is out of date.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
deps_profile(target, ..., character_only = FALSE, config = NULL)
}
\arguments{
\item{target}{Name of the target.}

\item{...}{Arguments to \code{\link[=make]{make()}}, such as \code{plan} and \code{targets}.}

\item{character_only}{Logical, whether to assume \code{target}
is a character string rather than a symbol.}

\item{config}{Deprecated.}
}
\value{
A data frame of old and new values for each
of the main triggers, along with
an indication of which values changed since
the last \code{\link[=make]{make()}}.
}
\description{
The dependency profile can give you
a hint as to why a target is out of date.
It can tell you if
\itemize{
\item the command changed
(\code{\link[=deps_profile]{deps_profile()}} reports the \emph{hash} of the command,
not the command itself)
\item at least one input file changed,
\item at least one output file changed,
\item or a non-file dependency changed. For this last part,
the imports need to be up to date in the cache,
which you can do with \code{outdated()} or
\code{make(skip_targets = TRUE)}.
\item the pseudo-random number generator seed changed.
Unfortunately, \code{deps_profile()} does not
currently get more specific than that.
}
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Load drake's canonical example.
make(my_plan) # Run the project, build the targets.
# Get some example dependency profiles of targets.
deps_profile(small, my_plan)
# Change a dependency.
simulate <- function(x) {}
# Update the in-memory imports in the cache
# so deps_profile can detect changes to them.
# Changes to targets are already cached.
make(my_plan, skip_targets = TRUE)
# The dependency hash changed.
deps_profile(small, my_plan)
}
})
}
}
\seealso{
\code{\link[=diagnose]{diagnose()}},
\code{\link[=deps_code]{deps_code()}}, \code{\link[=make]{make()}},
\code{\link[=drake_config]{drake_config()}}
}
