### some further examples:
require(distrMod)
options("newDevice"=TRUE)

### Poisson Family
P <- PoisFamily(3)
# generate data
x <- r(P)(40)
MLEstimator(x,P)

#Evaluations of Maximum likelihood estimate:
#-------------------------------------------
#An object of class Estimate
#generated by call
#  MLEstimator(x = x, ParamFamily = P)
#samplesize:   40
#estimate:
#
#  3.050000
# (0.276134)
#asymptotic (co)variance (multiplied with samplesize):
#[1] 3.05
#Criterion:
#negative log-likelihood
#               82.92266

MDEstimator(x,P)

#Evaluations of Minimum Kolmogorov distance estimate:
#----------------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = P)
#samplesize:   40
#estimate:
#  lambda
#3.049777
#Criterion:
#Kolmogorov distance
#         0.08891945

MDEstimator(x,P, distance = CvMDist, asvar.fct = distrMod:::.CvMMDCovariance)

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = P, distance = CvMDist, asvar.fct = distrMod:::.CvMMDCovariance)
#samplesize:   40
#estimate:
#    lambda
#  2.9561034
# (0.3855664)
#asymptotic (co)variance (multiplied with samplesize):
#[1] 5.946458
#Criterion:
#CvM distance
#  0.04909021

MDEstimator(x,P, distance = CvMDist, mu = Norm())

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = P, distance = CvMDist, mu = Norm())
#samplesize:   40
#estimate:
#  lambda
#2.840035
#Criterion:
#CvM distance
#  0.02739709

MDEstimator(x,P, distance = TotalVarDist)

#Evaluations of Minimum total variation distance estimate:
#---------------------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = P, distance = TotalVarDist)
#samplesize:   40
#estimate:
#  lambda
#2.987849
#Criterion:
#total variation distance
#               0.2543123

### Beta Family
B <- BetaFamily(2,4)
# generate data
x <- r(B)(40)
distroptions(DistrResolution = 1e-10)
MDEstimator(x, B, distance = TotalVarDist)

#Evaluations of Minimum total variation distance estimate:
#---------------------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = B, distance = TotalVarDist)
#samplesize:   40
#estimate:
#  shape1   shape2
#3.843629 7.338333
#Criterion:
#total variation distance
#               0.7421599

MDEstimator(x, B)

#Evaluations of Minimum Kolmogorov distance estimate:
#----------------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = B)
#samplesize:   40
#estimate:
#  shape1   shape2
#4.140942 8.612960
#Criterion:
#Kolmogorov distance
#          0.0881627

MDEstimator(x, B, distance = CvMDist, asvar.fct = distrMod:::.CvMMDCovariance)

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = B, distance = CvMDist, asvar.fct = distrMod:::.CvMMDCovariance)
#samplesize:   40
#estimate:
#    shape1     shape2
#  4.362062   9.021663
# (1.175868) (2.501083)
#asymptotic (co)variance (multiplied with samplesize):
#          shape1   shape2
#shape1  55.30661 105.8183
#shape2 105.81828 250.2166
#Criterion:
#CvM distance
#  0.03793965

(MLE<-MLEstimator(x, B))

#Evaluations of Maximum likelihood estimate:
#-------------------------------------------
#An object of class Estimate
#generated by call
#  MLEstimator(x = x, ParamFamily = B)
#samplesize:   40
#estimate:
#    shape1      shape2
#  3.8799534   8.3454158
# (0.8356662) (1.8607859)
#asymptotic (co)variance (multiplied with samplesize):
#         shape1    shape2
#shape1 27.93352  56.60962
#shape2 56.60962 138.50097
#Criterion:
#negative log-likelihood
#              -26.44365

confint(MLE)

#A[n] asymptotic (CLT-based) confidence interval:
#          2.5 %    97.5 %
#shape1 2.242078  5.517829
#shape2 4.698342 11.992489
#Type of estimator: Maximum likelihood estimate
#samplesize:   40
#Call by which estimate was produced:
#MLEstimator(x = x, ParamFamily = B)

### a new central distribution
my3d <- AbscontDistribution( d = function(x) exp(-abs(x)^3), withS = TRUE)
plot(my3d)
my3dF <- L2LocationScaleFamily(name = "my3dF",
                               centraldistribution = my3d)

plot(my3dF)

### generate some data out of the model
x <- r(my3dF)(40)*3+2
### evaluate the MLE:
MLEstimator(x,my3dF)

#Evaluations of Maximum likelihood estimate:
#-------------------------------------------
#An object of class Estimate
#generated by call
#  MLEstimator(x = x, ParamFamily = my3dF)
#samplesize:   40
#estimate:
#      loc        scale
#  1.8536010   3.3710549
# (0.3060706) (0.3077495)
#asymptotic (co)variance (multiplied with samplesize):
#           loc    scale
#loc   3.747169 0.000000
#scale 0.000000 3.788389
#Criterion:
#negative log-likelihood
#               85.14204

(MDE <- MDEstimator(x = x, ParamFamily = my3dF, distance = CvMDist))

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = my3dF, distance = CvMDist)
#samplesize:   40
#estimate:
#     loc    scale
#1.991751 3.758789
#Criterion:
#CvM distance
#  0.03114585
#
MDE.asvar <- distrMod:::.CvMMDCovariance(my3dF,
                 param = ParamFamParameter(main= estimate(MDE),
                           .returnClsName = "ParamWithScaleFamParameter"),
                 expon = 2, withplot = TRUE)

