% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIF.R
\name{DIF_mst}
\alias{DIF_mst}
\title{Exploratory test for Differential Item Functioning}
\usage{
DIF_mst(db, person_property, predicate = NULL)
}
\arguments{
\item{db}{an dexterMST db handle}

\item{person_property}{name of a person property defined in your dexterMST project}

\item{predicate}{logical predicate to select data to include in the analysis}
}
\description{
Compares two parameter objects and produces a test for DIF
based on equality of relative item difficulties category locations
}
\examples{
\dontrun{

dif = DIF_mst(db, person_property = 'test_mode')
print(dif)
plot(dif)

}
}
\references{
Bechger, T. M. and Maris, G (2015); A Statistical Test for Differential Item Pair Functioning. 
Psychometrika. Vol. 80, no. 2, 317-340.
}
