% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-mutate.R
\name{mutate.tbl_lazy}
\alias{mutate.tbl_lazy}
\title{Create, modify, and delete columns}
\usage{
\method{mutate}{tbl_lazy}(.data, ...)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Variables, or functions of
variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending order.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[=show_query]{show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
These are methods for the dplyr \code{\link[=mutate]{mutate()}} and \code{\link[=transmute]{transmute()}} generics.
They are translated to computed expressions in the \code{SELECT} clause of
the SQL query.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(x = 1:5, y = 5:1)
db \%>\%
  mutate(a = (x + y) / 2, b = sqrt(x^2L + y^2L)) \%>\%
  show_query()

# dbplyr automatically creates subqueries as needed
db \%>\%
  mutate(x1 = x + 1, x2 = x1 * 2) \%>\%
  show_query()
}
