% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge}
\alias{merge}
\alias{merge.dbi.table}
\title{Merge two dbi.tables}
\usage{
\method{merge}{dbi.table}(
  x,
  y,
  by = NULL,
  by.x = NULL,
  by.y = NULL,
  all = FALSE,
  all.x = all,
  all.y = all,
  sort = TRUE,
  suffixes = c(".x", ".y"),
  no.dups = TRUE,
  recursive = FALSE,
  ...
)
}
\arguments{
\item{x, y}{\code{\link{dbi.table}}s sharing the same DBI connection. If \code{y} is
not a \code{dbi.table} but does inherit from \code{data.frame}, then it is
coerced to a \code{dbi.table} using \code{\link{as.dbi.table}}. If \code{y}
is missing, a merge is performed for each of \code{x}'s foreign keys.}

\item{by}{a character vector of shared column names in \code{x} and \code{y} to merge
on.}

\item{by.x, by.y}{character vectors of column names in \code{x} and \code{y} to merge on.}

\item{all}{a logical value. \code{all = TRUE} is shorthand to save setting both
\code{all.x = TRUE} and \code{all.y = TRUE}.}

\item{all.x}{a logical value. When \code{TRUE}, rows from \code{x} that do not have a
matching row in \code{y} are included. These rows will have \code{NA}s in
the columns that are filled with values from \code{y}. The default is
\code{FALSE} so that only rows with data from both \code{x} and \code{y}
are included in the output.}

\item{all.y}{a logical value. Analogous to \code{all.x} above.}

\item{sort}{a logical value. When TRUE (default), the key of the merged
\code{dbi.table} is set to the \code{by} / \code{by.x} columns.}

\item{suffixes}{a length-2 character vector. The suffixes to be used for making
non-\code{by} column names unique. The suffix behavior works in a similar
fashion to the \code{\link[base]{merge.data.frame}} method.}

\item{no.dups}{a logical value. When \code{TRUE}, suffixes are also appended to
non-\code{by.y} column names in \code{y} when they have the same column
name as any \code{by.x}.}

\item{recursive}{a logical value. Only used when \code{y} is missing. When \code{TRUE},
\code{merge} is called on each \code{dbi.table} prior to merging with
\code{x}. See examples.}

\item{\dots}{additional arguments are passed to \code{\link{as.dbi.table}}.}
}
\value{
a \code{\link{dbi.table}}.
}
\description{
Merge two \code{\link{dbi.table}}s. By default, the columns to merge on are
  determined by the first of the following cases to apply.

  \enumerate{
    \item If \code{x} and \code{y} are each unmodified \code{dbi.table}s in
          the same \code{dbi.catalog} and if there is a single foreign key
          relating \code{x} and \code{y} (either \code{x} referencing
          \code{y}, or \code{y} referencing \code{x}), then it is used to set
          \code{by.x} and \code{by.y}.

    \item If \code{x} and \code{y} have shared key columns, then they are
          used to set \code{by} (that is,
          \code{by = intersect(key(x), key(y))} when
          \code{intersect(key(x), key(y))} has length greater than zero).

    \item If \code{x} has a key, then it is used to set \code{by} (that is,
          \code{by = key(x)} when \code{key(x)} has length greater than
          zero).

    \item If \code{x} and \code{y} have columns in common, then they are used
          to set
          \code{by} (that is, \code{by = intersect(names(x), names(y))} when
          \code{intersect(names(x), names(y))} has length greater than zero).
  }

  Use the \code{by}, \code{by.x}, and \code{by.y} arguments explicitly to
  override this default.
}
\details{
\code{merge.dbi.table} uses \code{\link{sql.join}} to join \code{x} and
  \code{y} then formats the result set to match the typical \code{merge}
  output.
}
\examples{
  chinook <- dbi.catalog(chinook.duckdb)

  #The Album table has a foreign key constriant that references Artist
  merge(chinook$main$Album, chinook$main$Artist)

  #When y is omitted, x's foreign key relationship is used to determine y
  merge(chinook$main$Album)

  #Track has 3 foreign keys: merge with Album, Genre, and MediaType
  merge(chinook$main$Track)

  #Track references Album but not Artist, Album references Artist
  #This dbi.table includes the artist name
  merge(chinook$main$Track, recursive = TRUE)

}
\seealso{
\code{\link[data.table]{merge.data.table}},
  \code{\link[base]{merge.data.frame}}
}
