% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_from_factor.R
\name{compute_probability_ratio}
\alias{compute_probability_ratio}
\title{Compute probability ratio}
\usage{
compute_probability_ratio(x)
}
\arguments{
\item{x}{A \code{list} of categorical elements}
}
\value{
P(most freq element) / (1 - P(most frq element))
}
\description{
Probability ratio is an aggregation function that can be used for 
\code{build_target_encoding}. Probability ratio is the P(most freq element) / (1 - P(most frq element)).
}
\details{
To be more generic, the library compute P(most freq element) inplace of traditional formula P(1)/P(0)
}
\examples{
# Build example list
example_list <- c(1, 1, 1, 2, 2, 3)

# Compute probability ratio
compute_probability_ratio(example_list)
}
