% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltn.R
\name{ltns}
\alias{ltns}
\title{Download data on 'Low Traffic Neighbourhoods' or 'rat runs' from CycleStreets}
\usage{
ltns(bb, pat = Sys.getenv("CYCLESTREETS"))
}
\arguments{
\item{bb}{An sf or 'bounding box' like object}

\item{pat}{The API key used. By default this uses \code{Sys.getenv("CYCLESTREETS")}.}
}
\description{
R interface to the CycleStreets.net LTN.
See \href{https://www.cyclestreets.net/api/v2/advocacydata.ltns/}{ltn API docs}
and an article on the methods for further details:
https://www.cyclestreets.org/news/2021/07/25/mapping-ltns/
}
\examples{
\dontrun{
bb <- "0.101131,52.195807,0.170288,52.209719"
ltn_data <- ltns(bb)
plot(ltn_data)
bb <- stplanr::routes_fast_sf
ltn_data <- ltns(bb)
plot(ltn_data)
}
}
