% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dfFindUniqueEuctrRecord}
\alias{dfFindUniqueEuctrRecord}
\title{Select single trial record from records of different EU Member States}
\usage{
dfFindUniqueEuctrRecord(
  df = NULL,
  prefermemberstate = "GB",
  include3rdcountrytrials = TRUE
)
}
\arguments{
\item{df}{A data frame created from the database that includes the columns
"_id" and "a2_eudract_number", for example created with function
dbGetFieldsIntoDf(c("_id", "a2_eudract_number")).}

\item{prefermemberstate}{Code of single EU Member State for which records
should returned. If not available, a record for GB or lacking this, any
other record for the trial will be returned. For a list of codes of EU
  Member States, please see vector \code{countriesEUCTR}. Alternatively,
  "3RD" will lead to return a Third Country record of a trial, if available.}

\item{include3rdcountrytrials}{A logical value if trials should be retained
that are conducted exclusively in third countries, that is, outside
the European Union.}
}
\value{
A data frame as subset of \code{df} corresponding to the sought
  records.
}
\description{
The EUCTR provides one record per trial per EU Member State in which the
trial is conducted. For all trials conducted in more than one Member State,
this function returns only one record per trial.
}
\details{
Note: To deduplicate trials from different registers (EUCTR and CTGOV),
please first use function \code{\link{dbFindIdsUniqueTrials}}.
}
\keyword{internal}
