% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrGenerateQueries.R
\name{ctrGenerateQueries}
\alias{ctrGenerateQueries}
\title{Generates queries that work across registers}
\usage{
ctrGenerateQueries(
  searchPhrase = NULL,
  condition = NULL,
  intervention = NULL,
  phase = NULL,
  population = NULL,
  recruitment = NULL,
  startBefore = NULL,
  startAfter = NULL,
  completedBefore = NULL,
  completedAfter = NULL,
  onlyMedIntervTrials = TRUE,
  onlyWithResults = FALSE,
  countries = NULL
)
}
\arguments{
\item{searchPhrase}{String with optional logical operators ("AND", "OR")
that will be searched in selected fields of registers that can handle logical
operators (general or title fields), should not include quotation marks}

\item{condition}{String with condition / disease}

\item{intervention}{String with intervention}

\item{phase}{String, e.g. "phase 2" (note that "phase 2+3" is a specific
category, not the union set of "phase 2" and "phase 3")}

\item{population}{String, e.g. "P" (paediatric), "A" (adult), "P+A"
(adult and paediatric), "E" (elderly), "P+A+E" participants can be recruited}

\item{recruitment}{String, one of "ongoing", "completed", "other" (
which includes "ended early" but this cannot be searched; use trial concept
\link{f.statusRecruitment} to identify this status)}

\item{startBefore}{String that can be interpreted as date (for EUCTR, when
trial was first registered)}

\item{startAfter}{String that can be interpreted as date (for EUCTR, when
trial was first registered)}

\item{completedBefore}{String that can be interpreted as date (does not work
with EUCTR)}

\item{completedAfter}{String that can be interpreted as date (does not work
with EUCTR)}

\item{onlyMedIntervTrials}{Logical, default \code{TRUE}, which indicates if
queries should search only for medicine interventional clinical trial}

\item{onlyWithResults}{Logical}

\item{countries}{Vector of country names, two- or three-letter ISO 3166 codes}
}
\value{
Named vector of URLs for finding trials in the registers and as
input to functions \link{ctrLoadQueryIntoDb} and
\link{ctrOpenSearchPagesInBrowser}
}
\description{
From high-level search terms provided by the user, generate specific queries
for each registers with which ctrdata works, see \link{ctrdata-registers}.
Search terms that are expanded to concepts such as from MeSH and MedDRA
by the search implementations in registers include the 'intervention' and
'condition'. Logical operators only work with 'searchPhrase'.
}
\examples{

urls <- ctrGenerateQueries(
  intervention = "antibody",
  phase = "phase 3",
  startAfter = "2000-01-01")

# open queries in register web interface
sapply(urls, ctrOpenSearchPagesInBrowser)

urls <- ctrGenerateQueries(
  searchPhrase = "antibody AND covid",
  recruitment = "completed",
  )

# count trials found
sapply(urls, ctrLoadQueryIntoDb, only.count = TRUE)

# load queries into database collection
# sapply(urls, ctrLoadQueryIntoDb, con = dbc)

# find research platform and platform trials
urls <- ctrGenerateQueries(
  searchPhrase = paste0(
   "basket OR platform OR umbrella OR master protocol OR ",
   "multiarm OR multistage OR subprotocol OR substudy OR ",
   "multi-arm OR multi-stage OR sub-protocol OR sub-study"),
 startAfter = "01/31/2010",
 countries = c("DE", "US", "United Kingdom"))

# open queries in register web interface
sapply(urls, ctrOpenSearchPagesInBrowser)

}
