% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbGetFieldsIntoDf.R
\name{dbGetFieldsIntoDf}
\alias{dbGetFieldsIntoDf}
\title{Create data frame of specified fields from database collection}
\usage{
dbGetFieldsIntoDf(fields = "", con, verbose = FALSE, ...)
}
\arguments{
\item{fields}{Vector of one or more strings, with names of sought fields.
See function \link{dbFindFields} for how to find names of fields and
\link{ctrShowOneTrial} for interactively selecting field names.
Dot path notation ("field.subfield") without indices is supported.
If compatibility with `nodbi::src_postgres()` is needed, specify fewer
than 50 fields, consider also using parent fields e.g., `"a.b"` instead
of `c("a.b.c.d", "a.b.c.e")`, accessing sought fields with
\link{dfTrials2Long} followed by \link{dfName2Value} or other R functions.}

\item{con}{A database connection object, created with
\code{nodbi}. See section `1 - Database connection` in
\link{ctrdata}.}

\item{verbose}{Printing additional information if set to \code{TRUE};
(default \code{FALSE}).}

\item{...}{Do not use (captures deprecated parameter \code{stopifnodata})}
}
\value{
A data frame (or tibble, if \code{tibble} is loaded)
with columns corresponding to the sought fields.
A column for the records' `_id` will always be included.
The maximum number of rows of the returned data frame is equal to,
or less than the number of trial records in the database collection.
}
\description{
Fields in the collection are retrieved from all records into a data
frame (or tibble). Within a given trial record, a fields can be
hierarchical and structured, that is, nested.
Th function uses the field names to appropriately type the values
that it returns, harmonising original values (e.g. "Information not present
in EudraCT" to `NA`, "Yes" to `TRUE`, "false" to `FALSE`,
date strings to dates or time differences, number strings to numbers).
The function simplifies the structure of nested data and
may concatenate multiple strings in a field using " / " (see example)
and may have widened the returned data frame with additional columns that
were recursively expanded from simply nested data (e.g., "externalRefs"
to columns "externalRefs.doi", "externalRefs.eudraCTNumber" etc.).
For an alternative way for handling the complex nested data, see
\link{dfTrials2Long} followed by \link{dfName2Value} for extracting
the sought variable(s).
}
\examples{

dbc <- nodbi::src_sqlite(
   dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
   collection = "my_trials",
   RSQLite::SQLITE_RO)

# get fields that are nested within another field
# and can have multiple values with the nested field
dbGetFieldsIntoDf(
  fields = "b1_sponsor.b31_and_b32_status_of_the_sponsor",
  con = dbc)

# fields that are lists of string values are
# returned by concatenating values with a slash
dbGetFieldsIntoDf(
  fields = "keyword",
  con = dbc)

}
