% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ctrLoadQueryIntoDb}
\alias{ctrLoadQueryIntoDb}
\title{Load and store register trial information}
\usage{
ctrLoadQueryIntoDb(
  queryterm = NULL,
  register = "",
  querytoupdate = NULL,
  forcetoupdate = FALSE,
  euctrresults = FALSE,
  euctrresultshistory = FALSE,
  euctrresultsfilespath = euctrresultspdfpath,
  euctrresultspdfpath = NULL,
  annotation.text = "",
  annotation.mode = "append",
  parallelretrievals = 10L,
  only.count = FALSE,
  con = NULL,
  verbose = FALSE
)
}
\arguments{
\item{queryterm}{Either a string with the full URL of a search in
a register, or the data frame returned by the
\link{ctrGetQueryUrl} or the
\link{dbQueryHistory} functions, or, together with parameter
\code{register}, a string with query elements of a search URL.
The queryterm is recorded in the \code{collection} for later
use to update records.}

\item{register}{String with abbreviation of register to query,
either "EUCTR", "CTGOV" or "ISRCTN". Not needed
if \code{queryterm} provide the information which register to
query (see \code{queryterm}).}

\item{querytoupdate}{Either the word "last" or the number of the
query (based on \link{dbQueryHistory}) that should be run to
retrieve any trial records that are new or have been updated
since this query was run the last time.
This parameter takes precedence over \code{queryterm}.
For EUCTR, updates are available only for the last seven days;
the query is run again if more time has passed since it was
run last.}

\item{forcetoupdate}{If \code{TRUE}, run again the query
given in \code{querytoupdate}, irrespective of when it was
run last (default is \code{FALSE}).}

\item{euctrresults}{If \code{TRUE}, also download available
results when retrieving and loading trials from EUCTR. This
slows down this function. (For CTGOV, all available results
are always retrieved and loaded.)}

\item{euctrresultshistory}{If \code{TRUE}, also download
available history of results publication in EUCTR.
This is quite time-consuming (default is \code{FALSE}).}

\item{euctrresultsfilespath}{If this is a relative or absolute
path to a  directory that exists or can be created,
save results files into it, e.g., PDF files of result publications
that had been submitted to EUCTR (default is \code{NULL}).}

\item{euctrresultspdfpath}{Deprecated, use \code{euctrresultsfilespath}}

\item{annotation.text}{Text to be including in the records
retrieved with the current query, in the field "annotation".}

\item{annotation.mode}{One of "append" (default), "prepend"
or "replace" for new annotation.text with respect to any
existing annotation for the records retrieved with the
current query.}

\item{parallelretrievals}{Number of parallel downloads of
information from the register, defaults to 10.}

\item{only.count}{Set to \code{TRUE} to return only the
number of trial records found in the register for the query.
Does not load trial information into the database.
Default is \code{FALSE}.}

\item{con}{A connection object, see section
`Databases` in \link{ctrdata-package}}

\item{verbose}{Printing additional information if set to
\code{TRUE}; default is \code{FALSE}.}
}
\value{
A list with elements
`n` (number of trial records newly imported or updated),
`success` (a vector of _id's of successfully loaded records),
`failed` (a vector of identifiers of records that failed to load)
and `queryterm` (the query term used).
The returned list has several attributes (including database and
collection name, as well as the query history of this database
collection) to facilitate documentation.
}
\description{
Retrieves or updates information on clinical trials from registers
and stores it in a collection in a database.
This is the main function of \link{ctrdata-package} for accessing
registers and loading trial information into a database collection,
even if from different queries or different registers.
The query details are stored in the database collection and can
be accessed using \link{dbQueryHistory}.
A previous query can be re-run, which replaces or adds trial
records. However, user annotations of trial records are kept.
}
\examples{
\dontrun{
dbc <- nodbi::src_sqlite(collection = "my_collection")

# Retrieve protocol- and results-related information
# on a single trial identified by its EU number
ctrLoadQueryIntoDb(
  queryterm = "2013-001291-38",
  register = "EUCTR",
  euctrresults = TRUE,
  con = dbc
)

# Retrieve all information on about 2,000 ongoing
# interventional cancer trials involving children
# into the same collection as used before
ctrLoadQueryIntoDb(
  queryterm = "cancer&recr=Open&type=Intr&age=0",
  register = "CTGOV",
  con = dbc
)

}

}
