% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_list.R
\name{fiat_list}
\alias{fiat_list}
\title{Retrieves list of all CMC supported fiat currencies available to convert cryptocurrencies}
\usage{
fiat_list(include_metals = FALSE)
}
\arguments{
\item{include_metals}{Shall the results include precious metals (TRUE) or not (FALSE=default).
Update: As of May 2024 no more metals are included in this file}
}
\value{
List of (active and historically existing) cryptocurrencies in a tibble:
\item{id}{CMC id (unique identifier)}
\item{symbol}{Coin symbol (not-unique)}
\item{name}{Coin name}
\item{sign}{Fiat currency sign}
}
\description{
This code retrieves data for all available fiat currencies that are available on the website.
}
\examples{
\dontrun{
# return fiat currencies available through the CMC api
fiat_list <- fiat_list()
}

}
