% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_relation.R
\name{sch_has_any_relation}
\alias{sch_has_any_relation}
\title{Has Any Relation}
\usage{
sch_has_any_relation(sch)
}
\arguments{
\item{sch}{A schedule object.}
}
\value{
A logical value:
\itemize{
\item TRUE: The schedule has any relation;
\item FALSE: The schedule do not have any relation.
}
}
\description{
A logical value that indicates if the schedule has any relation.
A TRUE value means that the schedule has some relation;
a FALSE, means that the schedule do not have any relation.
}
\examples{
sch <- sch_new()
sch_has_any_relation(sch) # FALSE

sch <- sch_new() \%>\%
  sch_add_activity(1L, "A", 2L) \%>\%
  sch_add_activity(2L, "B", 5L, 1L, direction = "pred")
sch_has_any_activity(sch) # TRUE

}
\seealso{
\code{\link[=sch_topoi_la]{sch_topoi_la()}}, \code{\link[=sch_relations]{sch_relations()}}, \code{\link[=sch_add_relations]{sch_add_relations()}},
\code{\link[=sch_topoi_sp]{sch_topoi_sp()}}, \code{\link[=sch_has_any_activity]{sch_has_any_activity()}}, \code{\link[=sch_all_predecessors]{sch_all_predecessors()}},
\code{\link[=sch_topoi_ad]{sch_topoi_ad()}}, \code{\link[=sch_nr_relations]{sch_nr_relations()}}, \code{\link[=sch_all_successors]{sch_all_successors()}},
\code{\link[=sch_nr_activities]{sch_nr_activities()}}, \code{\link[=sch_topoi_tf]{sch_topoi_tf()}}.
}
