% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_activity.R
\name{sch_has_any_activity}
\alias{sch_has_any_activity}
\title{Has Any Activity}
\usage{
sch_has_any_activity(sch)
}
\arguments{
\item{sch}{A schedule object.}
}
\value{
A logical value:
\itemize{
\item TRUE: The schedule has any activity;
\item FALSE: The schedule do not have any activity.
}
}
\description{
A logical value that indicates if the schedule has any activity.
A TRUE value means that the schedule has any activity;
a FALSE, means that the schedule do not have any activity.
}
\examples{
sch <- sch_new()
sch_has_any_activity(sch) # FALSE

sch <- sch_new() \%>\%
  sch_add_activity(1L, "Only one", 0L) \%>\%
  sch_plan()
sch_has_any_activity(sch) # TRUE

}
\seealso{
\code{\link[=sch_nr_activities]{sch_nr_activities()}}, \code{\link[=sch_critical_activities]{sch_critical_activities()}},
\code{\link[=sch_add_activities]{sch_add_activities()}}, \code{\link[=sch_change_activities_duration]{sch_change_activities_duration()}},
\code{\link[=sch_activities]{sch_activities()}}, \code{\link[=sch_nr_relations]{sch_nr_relations()}}, \code{\link[=sch_has_any_relation]{sch_has_any_relation()}},
\code{\link[=sch_add_activity]{sch_add_activity()}}.
}
