% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_async.R
\name{crew_async}
\alias{crew_async}
\title{Local asynchronous client object.}
\usage{
crew_async(workers = NULL)
}
\arguments{
\item{workers}{Number of local \code{mirai} daemons to run asynchronous tasks.
If \code{NULL}, then tasks will be evaluated synchronously.}
}
\value{
An \code{R6} async client object.
}
\description{
Create an \code{R6} object to manage local asynchronous quick
tasks with error detection.
}
\details{
\code{\link[=crew_async]{crew_async()}} objects are created inside launchers to allow
launcher plugins to run local tasks asynchronously, such as
calls to cloud APIs to launch serious remote workers.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
x <- crew_async()
x$start()
out <- x$eval(1 + 1)
mirai::call_mirai(out)
out$data # 2
x$terminate()
}
}
\seealso{
Other async: 
\code{\link{crew_class_async}}
}
\concept{async}
