crew_test("new queue is valid", {
  x <- crew_queue()
  expect_silent(x$validate())
  expect_equal(x$names, character(0L))
  expect_equal(x$head, 1L)
})

crew_test("basic set()", {
  x <- crew_queue()
  expect_true(x$empty())
  expect_false(x$nonempty())
  x$set(c("a", "b", "c"))
  expect_false(x$empty())
  expect_true(x$nonempty())
  expect_equal(x$names, c("a", "b", "c"))
  expect_equal(x$head, 1L)
  expect_silent(x$validate())
})

crew_test("basic reset()", {
  x <- crew_queue()
  x$set(c("a", "b", "c"))
  expect_false(x$empty())
  expect_true(x$nonempty())
  x$pop()
  expect_false(x$empty())
  expect_true(x$nonempty())
  x$reset()
  expect_true(x$empty())
  expect_false(x$nonempty())
  expect_equal(x$names, character(0L))
  expect_equal(x$head, 1L)
  expect_silent(x$validate())
})

crew_test("basic pop()", {
  x <- crew_queue()
  expect_true(x$empty())
  expect_false(x$nonempty())
  expect_null(x$pop())
  expect_equal(x$popped(), character(0L))
  x$set(c("a", "b", "c"))
  expect_equal(x$popped(), character(0L))
  expect_false(x$empty())
  expect_true(x$nonempty())
  expect_equal(x$pop(), "a")
  expect_equal(x$popped(), "a")
  expect_silent(x$validate())
  expect_equal(x$names, c("a", "b", "c"))
  expect_equal(x$head, 2L)
  expect_equal(x$pop(), "b")
  expect_equal(x$popped(), c("a", "b"))
  expect_false(x$empty())
  expect_true(x$nonempty())
  expect_silent(x$validate())
  expect_equal(x$names, c("a", "b", "c"))
  expect_equal(x$head, 3L)
  expect_equal(x$pop(), "c")
  expect_equal(x$popped(), c("a", "b", "c"))
  expect_true(x$empty())
  expect_false(x$nonempty())
  expect_silent(x$validate())
  expect_equal(x$names, c("a", "b", "c"))
  expect_equal(x$head, 4L)
  for (index in seq_len(3L)) {
    expect_null(x$pop())
    expect_equal(x$popped(), c("a", "b", "c"))
    expect_true(x$empty())
    expect_false(x$nonempty())
    expect_silent(x$validate())
    expect_equal(x$names, c("a", "b", "c"))
    expect_equal(x$head, 4L)
  }
  x$reset()
  expect_equal(x$popped(), character(0L))
  expect_silent(x$validate())
  expect_equal(x$names, character(0L))
  expect_equal(x$head, 1L)
})

crew_test("set() resets the queue with entirely new data", {
  x <- crew_queue()
  expect_null(x$pop())
  x$set(c("a", "b", "c", "d"))
  expect_equal(x$pop(), "a")
  expect_equal(x$pop(), "b")
  expect_equal(x$popped(), c("a", "b"))
  expect_silent(x$validate())
  expect_equal(x$names, c("a", "b", "c", "d"))
  expect_equal(x$head, 3L)
  x$set(names = c("x", "y", "z"))
  expect_equal(x$popped(), character(0L))
  expect_silent(x$validate())
  expect_equal(x$names, c("x", "y", "z"))
  expect_equal(x$head, 1L)
  x$reset()
  expect_equal(x$popped(), character(0L))
  expect_silent(x$validate())
  expect_equal(x$names, character(0L))
  expect_equal(x$head, 1L)
})

crew_test("collect() without previous pop()", {
  x <- crew_queue()
  expect_null(x$collect())
  x$set(c("a", "b", "c", "d"))
  expect_equal(x$popped(), character(0L))
  expect_equal(x$collect(), c("a", "b", "c", "d"))
  expect_equal(x$popped(), character(0L))
  expect_true(x$empty())
  expect_false(x$nonempty())
  expect_equal(x$names, character(0L))
  expect_equal(x$head, 1L)
})

crew_test("collect() with previous pop()", {
  x <- crew_queue()
  x$set(c("a", "b", "c", "d"))
  expect_equal(x$pop(), "a")
  expect_equal(x$popped(), "a")
  expect_equal(x$pop(), "b")
  expect_equal(x$popped(), c("a", "b"))
  expect_equal(x$collect(), c("c", "d"))
  expect_equal(x$popped(), character(0L))
  expect_equal(x$names, character(0L))
  expect_equal(x$head, 1L)
})
