% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{rearrange}
\alias{rearrange}
\title{Re-arrange a correlation data frame}
\usage{
rearrange(x, method = "PC", absolute = TRUE)
}
\arguments{
\item{x}{cor_df. See \code{\link{correlate}}.}

\item{method}{String specifying the arrangement (clustering) method.
Clustering is achieved via \code{\link[seriation]{seriate}}, which can be
consulted for a complete list of clustering methods. Default = "PCA".}

\item{absolute}{Boolean whether absolute values for the correlations should
be used for clustering.}
}
\value{
cor_df. See \code{\link{correlate}}.
}
\description{
Re-arrange a correlation data frame to group highly correlated variables closer
together.
}
\examples{
x <- correlate(mtcars)

rearrange(x) # Default settings
rearrange(x, method = "HC")  # Different seriation method
rearrange(x, absolute = FALSE)  # Not using absolute values for arranging
}
