% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fishp.R
\name{fishp}
\alias{fishp}
\title{Calculate Fisher's method p-value and meta-analysis statistics}
\usage{
fishp(df, vars, df_sigma, sum_sigma)
}
\arguments{
\item{df}{data frame with "markname" and study names as column names.}

\item{vars}{character vector of study names to include in the meta-analysis.}

\item{df_sigma}{data frame of tetrachoric correlations.}

\item{sum_sigma}{sum of tetrachoric correlations.}
}
\value{
A data frame with columns 'markname', 'sum_chisq', 'sum_z',
'sum_sigma_var', 'pvalue', 'meta_z', 'meta_p', 'meta_nlog10p'
}
\description{
Calculate Fisher's method p-value and meta-analysis statistics
}
\examples{
  data(snp_example)
  head(snp_example)
  varlist <- c("trt1","trt2","trt3")
  tc <- tetracorr(snp_example, varlist)
  fishp(snp_example, varlist, tc$sigma, tc$sum_sigma)
}
