% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{cf}
\alias{cf}
\title{Control-Function}
\usage{
cf(formula, d1 = NULL, d2 = NULL)
}
\arguments{
\item{formula}{A formula describing the model to be fitted.}

\item{d1}{The baseline treatment value.}

\item{d2}{The target treatment value.}
}
\value{
\code{cf} returns an object of class "cf", which is a list containing the following components:
   \item{\code{coefficients}}{The estimate of the coefficients in the outcome model.}
   \item{\code{vcov}}{The estimated covariance matrix of coefficients.}
   \item{\code{CausalEffect}}{The causal effect when the treatment changes from \code{d1} to \code{d2}.}
   \item{\code{CausalEffect.sd}}{The standard error of the causal effect estimator.}
   \item{\code{CausalEffect.ci}}{The 95\% confidence interval of the causal effect.}
}
\description{
Implement the control function method for the inference of nonlinear treatment effects.
}
\details{
For example, the formula \code{Y ~ D + I(D^2)+X|Z+I(Z^2)+X} describes the models
\eqn{Y = \alpha_0 + D\beta_1 + D^2\beta_2 + X\phi + u}
and
\eqn{D = \gamma_0 + Z\gamma_1 + Z^2\gamma_2 + X\psi + v}.
Here, the outcome is \code{Y}, the endogenous variables is \code{D}, the baseline covariates are \code{X}, and the instrument variables are \code{Z}. The formula environment follows
that in the ivreg function in the AER package. The endogenous variable \code{D} must be in the first term of the formula for the outcome model.
If either one of \code{d1} or \code{d2} is missing or \code{NULL}, \code{CausalEffect} is calculated assuming that the baseline value \code{d1} is the median of the treatment and the target value \code{d2} is \code{d1+1}.
}
\examples{
data("nonlineardata")
Y <- log(nonlineardata[,"insulin"])
D <- nonlineardata[,"bmi"]
Z <- as.matrix(nonlineardata[,c("Z.1","Z.2","Z.3","Z.4")])
X <- as.matrix(nonlineardata[,c("age","sex")])
cf.model <- cf(Y~D+I(D^2)+X|Z+I(Z^2)+X)
summary(cf.model)

}
\references{
{
Guo, Z. and D. S. Small (2016), Control function instrumental variable estimation of nonlinear causal effect models, \emph{The Journal of Machine Learning Research} 17(1), 3448–3482. \cr
}
}
