% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fill_gradient.R
\name{rule_fill_gradient_}
\alias{rule_fill_gradient_}
\title{Fill column with sequential colour gradient (standard evaluation)}
\usage{
rule_fill_gradient_(columns, expression = ~., low = "#132B43",
  high = "#56B1F7", space = "Lab", na.value = "#7F7F7F", limits = NA,
  lockcells = FALSE)
}
\arguments{
\item{columns}{a character vector with the column names or a list with
dplyr select helpers given as formulas or a combination of both}

\item{expression}{a formula to be evaluated with the data that will be used
to determine which cells are to be coloured. See the examples
to use it programmatically}

\item{low}{colour for low end of gradient.}

\item{high}{colour for high end of gradient.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{fill color for missing values}

\item{limits}{range of limits that the gradient should cover}

\item{lockcells}{logical value determining if no further rules should be applied to the affected cells.}
}
\description{
Fills the background color of a column using a gradient based on
the values given by an expression
}
\examples{
data(iris)
condformat(iris[1:5,]) + rule_fill_gradient_(columns=c("Sepal.Length"))
ex1 <- condformat(iris[1:5,]) +
  rule_fill_gradient_("Species", expression=~Sepal.Length-Sepal.Width)
# Use it programmatically:
gradient_color_column1_minus_column2 <- function(x, column_to_paint, column1, column2) {
  condformat(x) +
    rule_fill_discrete_(column_to_paint,
     expression=~ uq(as.name(column1)) - uq(as.name(column2)))
}
ex2 <- gradient_color_column1_minus_column2(iris[1:5,], "Species", "Sepal.Length", "Sepal.Width")
stopifnot(ex1 == ex2)
}
\seealso{
Other rule: \code{\link{rule_fill_discrete_}},
  \code{\link{rule_fill_discrete}},
  \code{\link{rule_fill_gradient2_}},
  \code{\link{rule_fill_gradient2}},
  \code{\link{rule_fill_gradient}}
}
