% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fill_gradient.R
\name{rule_fill_gradient}
\alias{rule_fill_gradient}
\title{Fill column with sequential colour gradient}
\usage{
rule_fill_gradient(..., expression, low = "#132B43", high = "#56B1F7",
  space = "Lab", na.value = "#7F7F7F", limits = NA, lockcells = FALSE)
}
\arguments{
\item{...}{Comma separated list of unquoted column names.
If \code{expression} is also given, then this list can use any of the
\code{\link[dplyr]{select}} syntax possibilities.}

\item{expression}{an expression to be evaluated with the data.
It should evaluate to a numeric vector,
that will be used to determine the colour gradient level.}

\item{low}{colour for low end of gradient.}

\item{high}{colour for high end of gradient.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{fill color for missing values}

\item{limits}{range of limits that the gradient should cover}

\item{lockcells}{logical value determining if no further rules should be applied to the affected cells.}
}
\value{
The condformat_tbl object, with the added formatting information
}
\description{
Fills the background color of a column using a gradient based on
the values given by an expression
}
\examples{
data(iris)
condformat(iris[c(1:5, 70:75, 120:125), ]) +
  rule_fill_gradient(Sepal.Length) +
  rule_fill_gradient(Species, expression=Sepal.Length - Sepal.Width)
}
\seealso{
Other rule: \code{\link{rule_fill_discrete_}},
  \code{\link{rule_fill_discrete}},
  \code{\link{rule_fill_gradient2_}},
  \code{\link{rule_fill_gradient2}},
  \code{\link{rule_fill_gradient_}}
}
