% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcm.R
\name{pcm}
\alias{pcm}
\title{Projected covariance measure test for conditional mean independence}
\usage{
pcm(
  Y,
  X,
  Z,
  rep = 1,
  est_vhat = TRUE,
  reg_YonXZ = "rf",
  reg_YonZ = "rf",
  reg_YhatonZ = "rf",
  reg_VonXZ = "rf",
  reg_RonZ = "rf",
  args_YonXZ = NULL,
  args_YonZ = NULL,
  args_YhatonZ = NULL,
  args_VonXZ = NULL,
  args_RonZ = NULL,
  frac = 0.5,
  indices = NULL,
  coin = FALSE,
  cointrol = NULL,
  return_fitted_models = FALSE,
  ...
)
}
\arguments{
\item{Y}{Vector of response values. Can be supplied as a numeric vector or
a single column matrix.}

\item{X}{Matrix or data.frame of covariates.}

\item{Z}{Matrix or data.frame of covariates.}

\item{rep}{Number of repetitions with which to repeat the PCM test}

\item{est_vhat}{Logical; whether to estimate the variance functional}

\item{reg_YonXZ}{Character string or function specifying the regression
for Y on X and Z, default is \code{"rf"} for random forest.
See \code{?\link[comets]{regressions}} for more detail.}

\item{reg_YonZ}{Character string or function specifying the regression
for Y on Z, default is \code{"rf"} for random forest.
See \code{?\link[comets]{regressions}} for more detail.}

\item{reg_YhatonZ}{Character string or function specifying the regression
for the predicted values of \code{reg_YonXZ} on Z, default is \code{"rf"}
for random forest.
See \code{?\link[comets]{regressions}} for more detail.}

\item{reg_VonXZ}{Character string or function specifying the regression
for estimating the conditional variance of Y given X and Z, default
is \code{"rf"} for random forest.
See \code{?\link[comets]{regressions}} for more detail.}

\item{reg_RonZ}{Character string or function specifying the regression
for the estimated transformation of Y, X, and Z on Z, default is
\code{"rf"} for random forest.
See \code{?\link[comets]{regressions}} for more detail.}

\item{args_YonXZ}{A list of named arguments passed to \code{reg_YonXZ}.}

\item{args_YonZ}{A list of named arguments passed to \code{reg_YonZ}.}

\item{args_YhatonZ}{A list of named arguments passed to \code{reg_YhatonZ}.}

\item{args_VonXZ}{A list of named arguments passed to \code{reg_VonXZ}.}

\item{args_RonZ}{A list of named arguments passed to \code{reg_RonZ}.}

\item{frac}{Relative size of train split.}

\item{indices}{A numeric vector of indices specifying the observations used
for estimating the estimating the direction (the other observations will
be used for computing the final test statistic). Default is \code{NULL}
and the indices will be generated randomly using \code{frac}.
When using \code{rep} larger than 1, a list (of length \code{rep}) of
indices can be supplied.}

\item{coin}{Logical; whether or not to use the \code{coin} package for
computing the test statistic and p-value. The \code{coin} package
computes variances with n - 1 degrees of freedom.
The default is \code{TRUE}.}

\item{cointrol}{List; further arguments passed to
\code{\link[coin]{independence_test}}.}

\item{return_fitted_models}{Logical; whether to return the fitted regressions
(default is \code{FALSE}).}

\item{...}{Additional arguments currently ignored.}
}
\value{
Object of class '\code{pcm}' and '\code{htest}' with the following
components:
\item{\code{statistic}}{The value of the test statistic.}
\item{\code{p.value}}{The p-value for the \code{hypothesis}}
\item{\code{parameter}}{In case X is multidimensional, this is the degrees of
    freedom used for the chi-squared test.}
\item{\code{hypothesis}}{Null hypothesis of conditional mean independence.}
\item{\code{null.value}}{Null hypothesis of conditional mean independence.}
\item{\code{method}}{The string \code{"Projected covariance measure test"}.}
\item{\code{data.name}}{A character string giving the name(s) of the data.}
\item{\code{check.data}}{A \code{data.frame} containing the residuals for plotting.}
\item{\code{models}}{List of fitted regressions if \code{return_fitted_models} is \code{TRUE}.}
}
\description{
Projected covariance measure test for conditional mean independence
}
\details{
The projected covariance measure test tests whether the conditional
mean of Y given X and Z is independent of X.
}
\examples{
n <- 1e2
X <- matrix(rnorm(2 * n), ncol = 2)
colnames(X) <- c("X1", "X2")
Z <- matrix(rnorm(2 * n), ncol = 2)
colnames(Z) <- c("Z1", "Z2")
Y <- X[, 2]^2 + Z[, 2] + rnorm(n)
(pcm1 <- pcm(Y, X, Z))

}
\references{
Lundborg, A. R., Kim, I., Shah, R. D., & Samworth, R. J. (2022). The
Projected Covariance Measure for assumption-lean variable significance
testing. arXiv preprint. \doi{10.48550/arXiv.2211.02039}
}
