% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_markers_statistics.R
\name{single_markers_statistics}
\alias{single_markers_statistics}
\title{Provide statistics for each marker.}
\usage{
single_markers_statistics(data_long)
}
\arguments{
\item{data_long}{a data.frame in long format returned by combiroc_long().}
}
\value{
a list object containing:
\itemize{
\item 'Statistics': a dataframe containing the main statistics for each marker in each class.
\item 'Plots': a named list of scatter plots showing signal intensity values.
}
}
\description{
A function that computes the statistics and a scatter-plot for each marker.
}
\details{
This function computes the main statistics of the signal values distribution of each marker in both classes. In addition it also shows the values through scatter plots.
}
\examples{
demo_data # combiroc built-in demo data (proteomics data from Zingaretti et al. 2012 - PMC3518104)

data_long <- combiroc_long(demo_data) # reshape data in long format

sms <- single_markers_statistics(data_long)

sms$Statistics # to visualize the statistics of each single marker
sms$Plots[[1]] # to visualize the scatterplot of the first marker
}
