% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coranking.R
\name{coranking}
\alias{coranking}
\title{Co-Ranking Matrix}
\usage{
coranking(
  Xi,
  X,
  input_Xi = c("data", "dist", "rank"),
  input_X = input_Xi,
  use = "C"
)
}
\arguments{
\item{Xi}{high dimensional data}

\item{X}{low dimensional data}

\item{input_Xi}{type of input of Xi (see. details)}

\item{input_X}{type of input of X (see. details)}

\item{use}{\code{R} or \code{C} backend}
}
\value{
a matrix of class \code{'coranking'}
}
\description{
Calculate the co-ranking matrix to assess the quality of a
diminsionality reduction.
}
\details{
Calculate the coranking matrix, to assess the quality of a dimensionality
reduction. \code{Xi} is input in high dimensions, \code{X} is input in low
dimensions the type of input is given in \code{input_Xi} and \code{input_X},
they can be one of \code{c('data', 'dist', 'rank')}.
}
\seealso{
\code{\link{rankmatrix}}
}
\author{
Guido Kraemer
}
