% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnum-tools.R
\name{tools}
\alias{tools}
\alias{is_cnum}
\alias{has_cnum}
\alias{extract_cnum}
\title{Chinese Numerals Detection and Extraction}
\usage{
is_cnum(
  x,
  lang = "tc",
  mode = "casual",
  financial = FALSE,
  literal = FALSE,
  strict = FALSE,
  ...
)

has_cnum(x, lang = "tc", mode = "casual", financial = FALSE, ...)

extract_cnum(x, lang = "tc", mode = "casual", financial = FALSE, ...)
}
\arguments{
\item{x}{the character object or string to be tested or to extract from.}

\item{lang}{the language of the Chinese numerals. \code{"tc"} for Traditional
Chinese. \code{"sc"} for Simplified Chinese.}

\item{mode}{the scale naming system to be enforced. See the ‘Details’ section
for the list of supported modes.}

\item{financial}{logical: should the financial numerals be used (\emph{daxie
shuzi})?}

\item{literal}{logical: should the numberals be converted literally? (e.g.
721 to be converted to "\emph{qi er yi}" instead of "\emph{qibai ershiyi}"
and vice versa)}

\item{strict}{logcial: Should the Chinese numerals format be strictly
enforced? A casual test only checks if \code{x} contains Chinese numerals
characters. A strict test checks if \code{x} is valid Chinese numerals.
(e.g. "\emph{yi bai yi}" will pass the casual test and fail the strcit
test)}

\item{...}{optional arguments to be passed to \code{\link[base]{grepl}} (for
\code{is_cnum} and \code{has_cnum}) or
\code{\link[stringr]{str_extract_all}} (for \code{extract_cnum}).
Disregarded when \code{strict = TRUE}.}
}
\value{
\code{is_cnum} returns a logical vector indicating is Chinese
  numerals or not for each element of \code{x}).

\code{has_cnum} returns a logical vector indicating contains Chinese
  numerals or not for each element of \code{x}).

\code{extract_cnum} returns a list of character vectors containing
  the extracted Chinese numerals.
}
\description{
Functions to detect and extract Chinese numerals in character object and
string.
}
\section{Functions}{
\itemize{
\item \code{is_cnum}: Test if character object is Chinese numerals

\item \code{has_cnum}: Test if string contains Chinese numerals

\item \code{extract_cnum}: Extract Chinese numerals from string
}}

\section{Details}{
 The following scale naming systems are supported: \itemize{
  \item {\code{"casual"}: }{the casual naming system used outside of mainland
  China, i.e. 1e+09 is referred to as "\emph{yi zhao}".} \item
  {\code{"casualPRC"}: }{the casual naming system used in mainland China,
  i.e. 1e+9 is referred to as "\emph{yi wanyi}".} \item {\code{"SIprefix"}:
  }{the SI prefix system used in Taiwan as stipulated in the document
  \emph{Names, Definitions and Symbols of the Legal Units of Measurement and
  the Decimal Multiples and Submultiples}.} \item{\code{"SIprefixPRC"}: }{the
  SI prefix system used in mainland China as stipulated in the document
  \emph{China Statutory Measurement Units}.} \item{\code{"SIprefixPRClong"}:
  }{ a variant of \code{"SIprefixPRC"} with long prefixes, e.g. 1e+09 is
  referred to as "\emph{jika}" instead of "\emph{ji}".} }
}

\examples{
is_cnum("hello")

has_cnum("hello")

extract_cnum("hello")

}
\seealso{
\link[=conversion]{Functions for conversion}
}
