% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levene.R
\name{levene_test}
\alias{levene_test}
\title{Levene's Test for Equality of Variance}
\usage{
levene_test(data = NULL, x, groups, alpha = 0.05, modcv = FALSE)
}
\arguments{
\item{data}{a data.frame}

\item{x}{the variable in the data.frame or a vector on which to perform the
Levene's test (usually strength)}

\item{groups}{a variable in the data.frame that defines the groups}

\item{alpha}{the significance level (default 0.05)}

\item{modcv}{a logical value indicating whether the modified CV approach
should be used.}
}
\value{
Returns an object of class \code{adk}. This object has the following fields:
\item{\code{call}}{the expression used to call this function}
\item{\code{data}}{the original data supplied by the user}
\item{\code{groups}}{a vector of the groups used in the computation}
\item{\code{alpha}}{the value of alpha specified}
\item{\code{modcv}}{a logical value indicating whether the modified
                    CV approach was used.}
\item{\code{n}}{the total number of observations}
\item{\code{k}}{the number of groups}
\item{\code{f}}{the value of the F test statistic}
\item{\code{p}}{the computed p-value}
\item{\code{reject_equal_variance}}{a boolean value indicating whether the
  null hypothesis that all samples have the same variance is rejected}
\item{\code{modcv_transformed_data}}{the data after the modified CV
                                     transformation}
}
\description{
This function performs the Levene's test for equality of variance.
}
\details{
This function performs the Levene's test for equality of variance. The
data is transformed as follows:

\deqn{w_{ij} = \left| x_{ij} - m_i \right|}{wij = | xij - mi |}

Where \eqn{m_i}{mi} is median of the \eqn{ith} group. An F-Test is then
performed on the transformed data.

When \code{modcv=TRUE}, the data from each group is first transformed
according to the modified coefficient of variation (CV) rules before
performing Levene's test.
}
\examples{
library(dplyr)

carbon.fabric.2 \%>\%
  filter(test == "FC") \%>\%
  levene_test(strength, condition)
##
## Call:
## levene_test(data = ., x = strength, groups = condition)
##
## n = 91          k = 5
## F = 3.883818    p-value = 0.00600518
## Conclusion: Samples have unequal variance ( alpha = 0.05 )

}
\references{
“Composite Materials Handbook, Volume 1. Polymer Matrix Composites
Guideline for Characterization of Structural Materials,” SAE International,
CMH-17-1G, Mar. 2012.
}
\seealso{
\code{\link{calc_cv_star}}

\code{\link{transform_mod_cv}}
}
