% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{comparison_alignedTargetCell}
\alias{comparison_alignedTargetCell}
\title{Extract a matrix from the target region of the same dimension as the reference
cell depending on the estimated translation calculated from comparison_fft_ccf}
\usage{
comparison_alignedTargetCell(
  cellHeightValues,
  regionHeightValues,
  target,
  theta,
  fft_ccf_df
)
}
\arguments{
\item{cellHeightValues}{list/tibble column of x3p objects containing a
reference scan's cells (as returned by comparison_cellDivision)}

\item{regionHeightValues}{list/tibble column of x3p objects containing a
target scan's regions (as returned by comparison_getTargetRegions)}

\item{target}{the scan to which each cell in the partitioned scan was
compared.}

\item{theta}{the theta (rotation) value associated with each cellHeightValues,
regionHeightValues pairing}

\item{fft_ccf_df}{data frame/tibble column containing the data frame of (x,y)
and CCF values returned by comparison_fft_ccf}
}
\value{
a list of x3p objects containing surface matrices extracted from
regionHeightValues of the same dimension as the x3p objects in
cellHeightValues
}
\description{
Extract a matrix from the target region of the same dimension as the reference
cell depending on the estimated translation calculated from comparison_fft_ccf
}
