% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{tables_get_enhancements_table_matchings}
\alias{tables_get_enhancements_table_matchings}
\title{View a table matching enhancement}
\usage{
tables_get_enhancements_table_matchings(id, source_table_id)
}
\arguments{
\item{id}{integer required. The ID of the enhancement.}

\item{source_table_id}{integer required. The ID of the table that was enhanced.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the enhancement.}
\item{sourceTableId}{integer, The ID of the table that was enhanced.}
\item{state}{string, The state of the enhancement, one of 'queued' 'running' 'succeeded' 'failed' or 'cancelled'.}
\item{enhancedTableSchema}{string, The schema name of the table created by the enhancement.}
\item{enhancedTableName}{string, The name of the table created by the enhancement.}
\item{threshold}{number, The confidence threshold which must be met for two individuals to be declared a match. Must be less than or equal to 1 and greater than or equal to 0.}
\item{maxMatches}{integer, The maximum number of individuals a person may be matched with.A value of 0 indicates that all matches should be returned.}
\item{matchTableId}{integer, The ID of the Redshift table to match against.}
}
\description{
View a table matching enhancement
}
