% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{jobs_get}
\alias{jobs_get}
\title{Show basic job info}
\usage{
jobs_get(id)
}
\arguments{
\item{id}{integer required. The ID for this job.}
}
\value{
A list containing the following elements:
\item{id}{integer, }
\item{name}{string, }
\item{type}{string, }
\item{fromTemplateId}{integer, }
\item{state}{string, Whether the job is idle, queued, running, cancelled, or failed.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{runs}{array, An array containing the following fields: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{hidden}{boolean, The hidden status of the item.}
\item{archived}{string, The archival status of the requested item(s).}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}
}
\description{
Show basic job info
}
