% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_xifti.R
\name{select_xifti}
\alias{select_xifti}
\title{Select columns of a \code{"xifti"}}
\usage{
select_xifti(xifti, idx, add_meta = "select")
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{idx}{The column indices to keep, in order.}

\item{add_meta}{Add \code{idx} to \code{xifti$meta$cifti$misc[[add_meta]]}
for reference. Default: \code{"select"}. If \code{NULL} or an empty string,
do not add a metadata entry.}
}
\value{
The \code{"xifti"} with only the selected columns.
}
\description{
Select column indices to keep in a \code{"xifti"}. Can also be used to
reorder the columns.
}
\seealso{
Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_to_dlabel}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
