% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_stan_state.R
\name{extract_stan_state}
\alias{extract_stan_state}
\title{Extract Stan State}
\usage{
extract_stan_state(object, phase)
}
\arguments{
\item{object}{An object of class \code{cmdstanr}}

\item{phase}{Character string indicating the current phase.
Options include \code{wormup} and \code{sample}/}
}
\value{
A list containing the inverse metric, step size, and last MCMC
draw (to be used as the initial value for the next checkpoint)
}
\description{
Extract Stan State
}
\examples{
\dontrun{
library(cmdstanr)

# eight schools example
fit_schools_ncp_mcmc <- cmdstanr_example("schools_ncp")

extract_stan_state(fit_schools_ncp_mcmc, "sample")
}
}
