% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{check_date}
\alias{check_date}
\alias{check_day}
\title{Check Date}
\usage{
check_date(x, coerce = FALSE, x_name = substitute(x), error = TRUE)

check_day(x, coerce = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce a date time (POSIXt scalar) to a Date and remove names.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a date (non-missing unnamed Date scalar).
}
\examples{
check_date(Sys.Date(), error = FALSE)
check_date(Sys.time(), error = FALSE)
check_date(Sys.time(), coerce = TRUE, error = FALSE)
}
\seealso{
\code{\link{check_datetime}}
}
