% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colnames.R
\name{check_colnames}
\alias{check_colnames}
\title{Check Colnames}
\usage{
check_colnames(x, colnames = character(0), exclusive = FALSE,
  order = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The data to check.}

\item{colnames}{A character vector of the column names.}

\item{exclusive}{A flag indicating whether other columns are not permitted.}

\item{order}{A flag indicating whether the columns have to occur in the same order as colnames.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks the column names of a data frame as returned by the `colnames()` function. 
The function can check the order of the columns and whether other columns are permitted.
}
\examples{
data <- data.frame(x = 1, y = 2, z = 0)
check_colnames(data, c("y", "x"), error = FALSE)
check_colnames(data, c("y", "x"), exclusive = TRUE, error = FALSE)
check_colnames(data, c("y", "x"), order = TRUE, error = FALSE)
check_colnames(data, c("a"), error = FALSE)
}
\seealso{
\code{\link{check_missing_colnames}} and \code{\link{check_data}}
}
