% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgam.R
\name{best.fit}
\alias{best.fit}
\title{Extract the Best Fit Returned by the ShapeSelect Routine}
\usage{
best.fit(x)
}
\arguments{
\item{x}{An object of the \code{ShapeSelect} class.}
}
\value{
The best fit returned by the \code{ShapeSelect} routine, which is an object of class \code{cgam}.
}
\description{
This is a subroutine that only works for the \code{ShapeSelect} routine.
It returns an object of the \code{cgam} class given the variables and their shapes
chosen by the \code{ShapeSelect} routine.
}
\examples{
\dontrun{
library(MASS)
data(Rubber)

# Perform variable and shape selection with four possible shapes:
# increasing, decreasing, convex, and concave
ans <- ShapeSelect(loss ~ shapes(hard, set = c("incr", "decr", "conv", "conc")) +
                   shapes(tens, set = c("incr", "decr", "conv", "conc")),
                   data = Rubber, genetic = TRUE)

# Extract the best fit (a cgam object)
bf <- best.fit(ans)
class(bf)
plotpersp(bf)
}

}
\seealso{
\code{\link{cgam}}, \code{\link{ShapeSelect}}
}
\author{
Xiyue Liao
}
\keyword{ShapeSelect}
\keyword{best}
\keyword{fit}
\keyword{of}
\keyword{routine}
\keyword{the}
