% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_conjunction.R, R/cf_variable.R
\name{counterfactual_conjunction}
\alias{counterfactual_conjunction}
\alias{format.counterfactual_conjunction}
\alias{print.counterfactual_conjunction}
\alias{+.counterfactual_conjunction}
\alias{[.counterfactual_conjunction}
\alias{+.counterfactual_variable}
\alias{conj}
\alias{counterfactual_variable}
\alias{format.counterfactual_variable}
\alias{print.counterfactual_variable}
\alias{cf}
\title{Counterfactual Conjunction}
\usage{
counterfactual_conjunction(...)

\method{format}{counterfactual_conjunction}(x, var_sep = " /\\\\ ", ...)

\method{print}{counterfactual_conjunction}(x, ...)

\method{+}{counterfactual_conjunction}(e1, e2)

\method{[}{counterfactual_conjunction}(x, i)

\method{+}{counterfactual_variable}(e1, e2)

conj(...)

counterfactual_variable(var, obs = integer(0L), sub = integer(0L))

\method{format}{counterfactual_variable}(x, use_primes = TRUE, ...)

\method{print}{counterfactual_variable}(x, ...)

cf(var, obs = integer(0L), sub = integer(0L))
}
\arguments{
\item{...}{Additional arguments passed to
\code{\link[=format.counterfactual_variable]{format.counterfactual_variable()}}.}

\item{x}{A \code{counterfactual_variable} or a \code{counterfactual_conjunction}
object.}

\item{var_sep}{A \code{character} string to separate counterfactual variables.}

\item{e1}{A \code{counterfactual_variable} or a \code{counterfactual_conjunction}
object.}

\item{e2}{A \code{counterfactual_variable} or a \code{counterfactual_conjunction}
object.}

\item{i}{An \code{integer} index vector.}

\item{var}{A character vector of length one naming the variable
(i.e., \eqn{Y}).}

\item{obs}{An integer vector of length one or zero. If given, denotes
the observed value of \code{var} (i.e., \eqn{Y = y})}

\item{sub}{A named integer vector where the names correspond to the
variables intervened on (via \eqn{do(X = x)}) and values to the
value assignments (their levels, e.g., \eqn{x}).}

\item{use_primes}{A \code{logical} value. If \code{TRUE} (the default), any value
assignment of a counterfactual variable with \code{obs} will be formatted with
as many primes in the superscript as the value of \code{obs}, e.g.,
\code{obs = 0} outputs \code{"y"}, \code{obs = 1} outputs \code{"y'"},
\code{obs = 2} outputs \code{"y''"} and so forth. The alternative when \code{FALSE} is
to simply denote the \code{obs} value via superscript directly as
\code{"y^{(obs)}"}, where obs is evaluated.}
}
\value{
\code{conj} returns an object of class \code{counterfactual_conjunction}.

\code{cf} returns an object of class \code{counterfactual_variable}.
}
\description{
\code{conj} defines a conjunction of counterfactual statements (variables).

\code{cf} defines a counterfactual variable \eqn{y_x}.
}
\section{Counterfactual Conjunctions}{

A counterfactual conjunction is a conjunction (or a set in some contexts)
of counterfactual statements that are assumed to hold simultaneously.

For example, the statement "The value of \eqn{Y} was observed to
be \eqn{y}, and the value of \eqn{Y} was observed to be \eqn{y'}
under the intervention \eqn{do(X = x)}" consists of two variables:
variable \eqn{Y} without intervention, and \eqn{Y} under the intervention
\eqn{do(X = x)} (which is \eqn{Y_x}). This conjunction can be succinctly
written as \eqn{y \wedge y'_x}.

Conjunctions can also be constructed
via the alias \code{conj} or iteratively from \code{counterfactual_variable}
objects (see examples).
}

\section{Counterfactual Variables}{

Assume that \eqn{Y} is a single variable and \eqn{X} is a vector
of variables. Here, The notation \eqn{y_x} means that the variable
\eqn{Y} (\code{var}) attains the value \eqn{y} (\code{obs}) under the
intervention \eqn{do(X = x)} (\code{sub}).

Note that different values of \code{obs} for a two variables with the same \code{var}
and the same \code{sub} do not denote their actual values, but the levels
(i.e., \code{obs = 0} is different from \code{obs = 1}, but the variables do not
actually attain values 0 and 1). In other words, if \code{var} is different for
two counterfactual variables, but they have the same value \code{obs}, this
does not mean that these variables have the same value. They will only
actually have the same value if they share both \code{var} and \code{obs}.

For more information about the
\eqn{do}-operator, see Pearl (2009). The shortcut alias \code{cf} can also
be used to construct counterfactual variables.
}

\examples{
# The conjunction described under 'details'
v1 <- cf("Y", 0)
v2 <- cf("Y", 1, c("X" = 0))
c1 <- conj(v1, v2)

# Alternative construction
c1 <- v1 + v2

# Adding further variables
v3 <- cf("X", 1)
c2 <- c1 + v3

# A specific value of a variable (a unique combination of `var` and `sub`)
# can only appear once in a given conjunction,
# otherwise the conjunction would be trivially inconsistent
v4 <- cf("Y", 0, c("X" = 0))
v5 <- cf("Y", 1, c("X" = 0))
c3 <- try(conj(v4, v5))

# Y without an assigned value or any interventions
cf("Y")

# Y with a value assignment y, but no interventions
cf("Y", 0)

# Y with a different value y', but no interventions
cf("Y", 1)

# Y with the same value as the previous under the intervention do(X = x)
cf("Y", 1, c("X" = 0))

# Y with yet another value y'', under the intervention
# do(X = x', Z = z), i.e., the intervention on X has a different value
# than the previous (x != x') and Z is also assigned the value z
cf("Y", 2, c("X" = 1, "Z" = 0))
}
