% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_to_bibtex.R
\name{cff_to_bibtex}
\alias{cff_to_bibtex}
\title{Create a BibTeX entry from a CITATION file or a \code{cff} object}
\usage{
cff_to_bibtex(x)
}
\arguments{
\item{x}{The source that would be used for generating
the \code{\link{cff}} object. It could be:
\itemize{
\item An existing \code{\link{cff}} object,
\item A CITATION.cff file.
}}
}
\value{
A \code{bibentry} object that can be parsed to BibTeX format with
\code{\link[=toBibtex]{toBibtex()}}
}
\description{
Creates a \code{bibentry} object (\code{\link[=bibentry]{bibentry()}}) from a \code{cff} object
}
\examples{
\donttest{

# From a cff object
package <- cff_create("rmarkdown")

obj <- cff_to_bibtex(package)

obj

toBibtex(obj)
}
}
\references{
\itemize{
\item Patashnik, Oren. "BIBTEXTING" February 1988.
\url{https://osl.ugr.es/CTAN/biblio/bibtex/base/btxdoc.pdf}.
\item Haines, R., & The Ruby Citation File Format Developers. (2021).
\emph{Ruby CFF Library (Version 0.9.0)} (Computer software).
\doi{10.5281/zenodo.1184077}.
}
}
\seealso{
\code{\link[=cff_parse_citation]{cff_parse_citation()}}, \code{\link[=bibentry]{bibentry()}}, \code{\link[=toBibtex]{toBibtex()}}

Other bibtex: 
\code{\link{cff_extract_to_bibtex}()},
\code{\link{encoded_utf_to_latex}()},
\code{\link{write_bib}()}
}
\concept{bibtex}
