% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_recruiting.R
\name{cfbd_recruiting_position}
\alias{cfbd_recruiting_position}
\title{\strong{Get college football position group recruiting information.}}
\usage{
cfbd_recruiting_position(
  start_year = NULL,
  end_year = NULL,
  team = NULL,
  conference = NULL
)
}
\arguments{
\item{start_year}{(\emph{Integer} optional): Start Year, 4 digit format (\emph{YYYY}). \emph{Note: 2000 is the minimum value}}

\item{end_year}{(\emph{Integer} optional): End Year,  4 digit format (\emph{YYYY}). \emph{Note: 2020 is the maximum value currently}}

\item{team}{(\emph{String} optional): Team - Select a valid team, D-I football}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_recruiting_position]{cfbd_recruiting_position()}} - A data frame with 7 variables:
\describe{
\item{\code{team}: character.}{Recruiting team.}
\item{\code{conference}: character.}{Recruiting team conference.}
\item{\code{position_group}: character.}{Position group of the recruits.}
\item{\code{avg_rating}: double.}{Average rating of the recruits in the position group.}
\item{\code{total_rating}: double.}{Sum of the ratings of the recruits in the position group.}
\item{\code{commits}: integer.}{Number of commits in the position group.}
\item{\code{avg_stars}: double.}{Average stars of the recruits in the position group.}
}
}
\description{
\strong{Get college football position group recruiting information.}
}
\examples{
\donttest{
  try(cfbd_recruiting_position(2018, team = "Texas"))

  try(cfbd_recruiting_position(2016, 2020, team = "Virginia"))

  try(cfbd_recruiting_position(2015, 2020, conference = "SEC"))
}

}
\keyword{Recruiting}
