% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_game_player_stats}
\alias{cfbd_game_player_stats}
\title{\strong{Get player statistics by game}}
\usage{
cfbd_game_player_stats(
  year,
  week = NULL,
  season_type = "regular",
  team = NULL,
  conference = NULL,
  category = NULL,
  game_id = NULL
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format(\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier)}

\item{season_type}{(\emph{String} default regular): Select Season Type: regular or postseason}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference\cr
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC\cr
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC\cr}

\item{category}{(\emph{String} optional): Category filter (e.g defensive)\cr
Offense: passing, receiving, rushing\cr
Defense: defensive, fumbles, interceptions\cr
Special Teams: punting, puntReturns, kicking, kickReturns\cr}

\item{game_id}{(\emph{Integer} optional): Game ID filter for querying a single game
Can be found using the \code{\link[=cfbd_game_info]{cfbd_game_info()}} function}
}
\value{
\code{\link[=cfbd_game_player_stats]{cfbd_game_player_stats()}} - A data frame with 32 variables:
\describe{
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{team}: character.}{Team name.}
\item{\code{conference}: character.}{Conference of the team.}
\item{\code{home_away}: character.}{Flag for if the team was the home or away team.}
\item{\code{points}: integer.}{Team points.}
\item{\code{category}: character.}{Statistic category.}
\item{\code{athlete_id}: character.}{Athlete referencing id.}
\item{\code{name}: character.}{Player name.}
\item{\code{c_att}: character.}{Completions - Pass attempts.}
\item{\code{yds}: double.}{Statistic yardage.}
\item{\code{avg}: double.}{Average per statistic.}
\item{\code{td}: double.}{Touchdowns scored.}
\item{\code{int}: double.}{Interceptions thrown.}
\item{\code{qbr}: double.}{Quarterback rating.}
\item{\code{car}: double.}{Number of rushing carries.}
\item{\code{long}: double.}{Longest carry/reception of the game.}
\item{\code{rec}: double.}{Number of pass receptions.}
\item{\code{no}: double.}{Player number.}
\item{\code{fg}: character.}{Field goal attempts in the game.}
\item{\code{pct}: double.}{Field goal percentage in the game.}
\item{\code{xp}: character.}{Extra points kicked in the game.}
\item{\code{pts}: double.}{Total kicking points in the game.}
\item{\code{tb}: double.}{Touchbacks (for kicking) in the game.}
\item{\code{in_20}: double.}{Punts inside the 20 yardline in the game.}
\item{\code{fum}: double.}{Player fumbles in the game.}
\item{\code{lost}: double.}{Player fumbles lost in the game.}
\item{\code{tot}: double.}{Total tackles in the game.}
\item{\code{solo}: double.}{Solo tackles in the game.}
\item{\code{sacks}: double.}{Total sacks in the game.}
\item{\code{tfl}: double.}{Total tackles for loss in the game.}
\item{\code{pd}: double.}{Total passes defensed in the game.}
\item{\code{qb_hur}: double.}{Total quarterback hurries in the game.}
}
}
\description{
\strong{Get player statistics by game}
}
\examples{
\donttest{
  cfbd_game_player_stats(year = 2020, week = 15, team = "Alabama")

  cfbd_game_player_stats(2013, week = 1, team = "Florida State", category = "passing")
}
}
\keyword{Game}
\keyword{Info}
