% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTiles.R
\name{getTiles}
\alias{getTiles}
\title{Get Tiles from Open Map Servers}
\usage{
getTiles(x, spdf, type = "osm", zoom = NULL, crop = FALSE,
  verbose = FALSE)
}
\arguments{
\item{x}{an sf object, a simple feature collection or a Spatial*DataFrame.}

\item{spdf}{deprecated, a Spatial*DataFrame with a valid projection attribute.}

\item{type}{the tile server from which to get the map, one of "osm", "hotstyle", 
"hikebike", "osmgrayscale", "stamenbw", "stamenwatercolor", "cartodark", 
"cartolight".}

\item{zoom}{the zoom level. If null, it is determined automatically 
(see Details).}

\item{crop}{TRUE if results should be cropped to the specified x extent, FALSE otherwise.}

\item{verbose}{if TRUE a progress bar is displayed.}
}
\value{
A RatserBrick is returned.
}
\description{
Get map tiles based on a spatial object extent. Maps can be 
fetched from various open map servers.
}
\details{
Zoom levels are described on the OpenStreetMap wiki: 
\url{http://wiki.openstreetmap.org/wiki/Zoom_levels}.
}
\note{
This function is a wrapper around the \code{osm.raster} function 
from the \code{rosm} package. \cr
Use directly the \href{https://CRAN.R-project.org/package=rosm}{rosm} package to have a finer control over  
extraction and display parameters.
}
\examples{
\dontrun{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# Download the tiles, extent = Martinique
mtqOSM <- getTiles(x = mtq, type = "osm", crop = TRUE)
# Plot the tiles
tilesLayer(mtqOSM)
# Plot countries
plot(st_geometry(mtq), add=TRUE)
txt <- "© OpenStreetMap contributors. Tiles style under CC BY-SA, www.openstreetmap.org/copyright"
mtext(text = txt, side = 1, adj = 0, cex = 0.7, font = 3)
}
}
\seealso{
\link{tilesLayer}
}
